/*
 * Decompiled with CFR 0.152.
 */
package voldemort.serialization;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SerializationUtils {
    private static final Logger logger = Logger.getLogger(SerializationUtils.class);

    public static String getJavaClassFromSchemaInfo(String schemaInfo) {
        String ONLY_JAVA_CLIENTS_SUPPORTED = "Only Java clients are supported currently, so the format of the schema-info should be: <schema-info>java=foo.Bar</schema-info> where foo.Bar is the fully qualified name of the message.";
        if (StringUtils.isEmpty((String)schemaInfo)) {
            throw new IllegalArgumentException("This serializer requires a non-empty schema-info.");
        }
        String[] languagePairs = StringUtils.split((String)schemaInfo, (char)',');
        if (languagePairs.length > 1) {
            throw new IllegalArgumentException("Only Java clients are supported currently, so the format of the schema-info should be: <schema-info>java=foo.Bar</schema-info> where foo.Bar is the fully qualified name of the message.");
        }
        String[] javaPair = StringUtils.split((String)languagePairs[0], (char)'=');
        if (javaPair.length != 2 || !javaPair[0].trim().equals("java")) {
            throw new IllegalArgumentException("Only Java clients are supported currently, so the format of the schema-info should be: <schema-info>java=foo.Bar</schema-info> where foo.Bar is the fully qualified name of the message.");
        }
        return javaPair[1].trim();
    }

    public static void close(ByteArrayOutputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                logger.error((Object)"Failed to close stream", (Throwable)e);
            }
        }
    }
}

