/*
 * Decompiled with CFR 0.152.
 */
package voldemort.server;

import java.util.concurrent.ThreadPoolExecutor;

public class StatusManager {
    private final ThreadPoolExecutor threadPool;
    private final long originalStartTime;

    public StatusManager(ThreadPoolExecutor threadPool) {
        this.threadPool = threadPool;
        this.originalStartTime = System.currentTimeMillis();
    }

    public long getWorkerPoolSize() {
        return this.threadPool.getPoolSize();
    }

    public long getActiveWorkersCount() {
        return this.threadPool.getActiveCount();
    }

    public long getUptime() {
        return (System.currentTimeMillis() - this.originalStartTime) / 1000L;
    }

    public String getFormattedUptime() {
        long time = this.getUptime();
        long days = time / 86400L;
        long hours = time / 3600L - days * 24L;
        long minutes = time / 60L - days * 1440L - hours * 60L;
        long seconds = time % 60L;
        return String.format("%d days, %d hours, %d minutes, %d seconds", days, hours, minutes, seconds);
    }
}

