/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.stats;

import com.google.common.collect.ImmutableList;
import voldemort.annotations.jmx.JmxGetter;
import voldemort.annotations.jmx.JmxManaged;
import voldemort.store.stats.StoreStats;
import voldemort.store.stats.Tracked;

@JmxManaged
public class StoreStatsJmx {
    private StoreStats stats;

    public StoreStatsJmx(StoreStats stats) {
        this.stats = stats;
    }

    @JmxGetter(name="numberOfCallsToGetAll", description="The number of calls to GET_ALL since the last reset.")
    public long getNumberOfCallsToGetAll() {
        return this.stats.getCount(Tracked.GET_ALL);
    }

    @JmxGetter(name="averageGetAllCompletionTimeInMs", description="The avg. time in ms for GET_ALL calls to complete.")
    public double getAverageGetAllCompletionTimeInMs() {
        return this.stats.getAvgTimeInMs(Tracked.GET_ALL);
    }

    @JmxGetter(name="GetAllThroughput", description="Throughput of GET_ALL requests.")
    public float getGetAllThroughput() {
        return this.stats.getThroughput(Tracked.GET_ALL);
    }

    @JmxGetter(name="GetAllThroughputInBytes", description="Throughput of GET_ALL requests in bytes.")
    public float getGetAllThroughputInBytes() {
        return this.stats.getThroughputInBytes(Tracked.GET_ALL);
    }

    @JmxGetter(name="averageGetAllCount", description="The avg. number of keys in a GET_ALL request.")
    public double getAverageGetAllCount() {
        return this.stats.getGetAllAverageCount();
    }

    @JmxGetter(name="maxGetAllCount", description="The max number of keys in a GET_ALL request.")
    public long getMaxGetAllCount() {
        return this.stats.getGetAllMaxCount();
    }

    @JmxGetter(name="numberOfCallsToGet", description="The number of calls to GET since the last reset.")
    public long getNumberOfCallsToGet() {
        return this.stats.getCount(Tracked.GET);
    }

    @JmxGetter(name="averageGetCompletionTimeInMs", description="The avg. time in ms for GET calls to complete.")
    public double getAverageGetCompletionTimeInMs() {
        return this.stats.getAvgTimeInMs(Tracked.GET);
    }

    @JmxGetter(name="GetThroughput", description="Throughput of GET requests")
    public float getGetThroughput() {
        return this.stats.getThroughput(Tracked.GET);
    }

    @JmxGetter(name="GetThroughputInBytes", description="Throughput of GET requests in bytes.")
    public float getGetThroughputInBytes() {
        return this.stats.getThroughputInBytes(Tracked.GET);
    }

    @JmxGetter(name="numberOfCallsToPut", description="The number of calls to PUT since the last reset.")
    public long getNumberOfCallsToPut() {
        return this.stats.getCount(Tracked.PUT);
    }

    @JmxGetter(name="averagePutCompletionTimeInMs", description="The avg. time in ms for PUT calls to complete.")
    public double getAveragePutCompletionTimeInMs() {
        return this.stats.getAvgTimeInMs(Tracked.PUT);
    }

    @JmxGetter(name="PutThroughput", description="Throughput of PUT requests.")
    public float getPutThroughput() {
        return this.stats.getThroughput(Tracked.PUT);
    }

    @JmxGetter(name="PutThroughputInBytes", description="Throughput of PUT requests in bytes.")
    public float getPutThroughputInBytes() {
        return this.stats.getThroughputInBytes(Tracked.PUT);
    }

    @JmxGetter(name="numberOfCallsToDelete", description="The number of calls to DELETE since the last reset.")
    public long getNumberOfCallsToDelete() {
        return this.stats.getCount(Tracked.DELETE);
    }

    @JmxGetter(name="averageDeleteCompletionTimeInMs", description="The avg. time in ms for DELETE calls to complete.")
    public double getAverageDeleteCompletionTimeInMs() {
        return this.stats.getAvgTimeInMs(Tracked.DELETE);
    }

    @JmxGetter(name="DeleteThroughput", description="Throughput of DELETE requests.")
    public float getDeleteThroughput() {
        return this.stats.getThroughput(Tracked.DELETE);
    }

    @JmxGetter(name="numberOfObsoleteVersions", description="Number of ObsoleteVersionExceptions since the last reset.")
    public long getNumberOfObsoleteVersions() {
        return this.stats.getCount(Tracked.OBSOLETE);
    }

    @JmxGetter(name="numberOfExceptions", description="The number of exceptions since the last reset.")
    public long getNumberOfExceptions() {
        return this.stats.getCount(Tracked.EXCEPTION);
    }

    @JmxGetter(name="averageOperationTimeInMs", description="The total number of all operations that have occured.")
    public double getAvgOperationCompletionTimeInMs() {
        double sum = 0.0;
        double weightedTime = 0.0;
        for (Tracked stat : ImmutableList.of((Object)((Object)Tracked.DELETE), (Object)((Object)Tracked.GET), (Object)((Object)Tracked.GET_ALL), (Object)((Object)Tracked.PUT))) {
            sum += (double)this.stats.getCount(stat);
            weightedTime += (double)this.stats.getCount(stat) * this.stats.getAvgTimeInMs(stat);
        }
        if (sum <= 0.0) {
            return 0.0;
        }
        return weightedTime / sum;
    }

    @JmxGetter(name="AllOperationThroughput", description="The throughput of all operations.")
    public double getOperationThroughput() {
        return this.stats.getThroughput(Tracked.DELETE) + this.stats.getThroughput(Tracked.GET) + this.stats.getThroughput(Tracked.GET_ALL) + this.stats.getThroughput(Tracked.PUT);
    }

    @JmxGetter(name="AllOperationThroughputInBytes", description="Throughput of all operations in bytes.")
    public double getOperationThroghputInBytes() {
        return this.stats.getThroughputInBytes(Tracked.GET) + this.stats.getThroughputInBytes(Tracked.GET_ALL) + this.stats.getThroughputInBytes(Tracked.PUT);
    }

    @JmxGetter(name="percentGetReturningEmptyResponse", description="The percentage of calls to GET for which no value was found.")
    public double getPercentGetReturningEmptyResponse() {
        return this.numEmptyResponses(this.stats.getNumEmptyResponses(Tracked.GET), this.stats.getCount(Tracked.GET));
    }

    @JmxGetter(name="percentGetAllReturningEmptyResponse", description="The percentage of calls to GET_ALL for which no value was found, taking into account multiple returned key-values.")
    public double getPercentGetAllReturningEmptyResponse() {
        return this.numEmptyResponses(this.stats.getNumEmptyResponses(Tracked.GET_ALL), this.stats.getGetAllAggregatedCount());
    }

    private double numEmptyResponses(long numEmpty, long total) {
        return total == 0L ? 0.0 : (double)((float)numEmpty / (float)total);
    }

    @JmxGetter(name="maxPutLatencyInMs", description="Maximum latency in ms of PUT")
    public long getMaxPutLatency() {
        return this.stats.getMaxLatencyInMs(Tracked.PUT);
    }

    @JmxGetter(name="maxGetLatencyInMs", description="Maximum latency in ms of GET")
    public long getMaxGetLatency() {
        return this.stats.getMaxLatencyInMs(Tracked.GET);
    }

    @JmxGetter(name="maxGetAllLatencyInMs", description="Maximum latency in ms of GET_ALL")
    public long getMaxGetAllLatency() {
        return this.stats.getMaxLatencyInMs(Tracked.GET_ALL);
    }

    @JmxGetter(name="maxDeleteLatencyInMs", description="Maximum latency in ms of DELETE")
    public long getMaxDeleteLatency() {
        return this.stats.getMaxLatencyInMs(Tracked.DELETE);
    }

    @JmxGetter(name="q95PutLatencyInMs", description="")
    public long getQ95PutLatency() {
        return this.stats.getQ95LatencyInMs(Tracked.PUT);
    }

    @JmxGetter(name="q95GetLatencyInMs", description="")
    public long getQ95GetLatency() {
        return this.stats.getQ95LatencyInMs(Tracked.GET);
    }

    @JmxGetter(name="q95GetAllLatencyInMs", description="")
    public long getQ95GetAllLatency() {
        return this.stats.getQ95LatencyInMs(Tracked.GET_ALL);
    }

    @JmxGetter(name="q95DeleteLatencyInMs", description="")
    public long getQ95DeleteLatency() {
        return this.stats.getQ95LatencyInMs(Tracked.DELETE);
    }

    @JmxGetter(name="q99PutLatencyInMs", description="")
    public long getQ99PutLatency() {
        return this.stats.getQ99LatencyInMs(Tracked.PUT);
    }

    @JmxGetter(name="q99GetLatencyInMs", description="")
    public long getQ99GetLatency() {
        return this.stats.getQ99LatencyInMs(Tracked.GET);
    }

    @JmxGetter(name="q99GetAllLatencyInMs", description="")
    public long getQ99GetAllLatency() {
        return this.stats.getQ99LatencyInMs(Tracked.GET_ALL);
    }

    @JmxGetter(name="q99DeleteLatencyInMs", description="")
    public long getQ99DeleteLatency() {
        return this.stats.getQ99LatencyInMs(Tracked.DELETE);
    }

    @JmxGetter(name="maxPutSizeInBytes", description="Maximum size of value returned in bytes by PUT.")
    public long getMaxPutSizeInBytes() {
        return this.stats.getMaxSizeInBytes(Tracked.PUT);
    }

    @JmxGetter(name="maxGetAllSizeInBytes", description="Maximum size of value returned in bytes by GET_ALL.")
    public long getMaxGetAllSizeInBytes() {
        return this.stats.getMaxSizeInBytes(Tracked.GET_ALL);
    }

    @JmxGetter(name="maxGetSizeInBytes", description="Maximum size of value returned in bytes by GET.")
    public long getMaxGetSizeInBytes() {
        return this.stats.getMaxSizeInBytes(Tracked.GET);
    }

    @JmxGetter(name="averageGetValueSizeInBytes", description="Average size in bytes of GET request")
    public double getAverageGetSizeInBytes() {
        return this.stats.getAvgSizeinBytes(Tracked.GET);
    }

    @JmxGetter(name="averageGetAllSizeInBytes", description="Average size in bytes of GET_ALL request")
    public double getAverageGetAllSizeInBytes() {
        return this.stats.getAvgSizeinBytes(Tracked.GET_ALL);
    }

    @JmxGetter(name="averagePutSizeInBytes", description="Average size in bytes of PUT request")
    public double getAveragePutSizeInBytes() {
        return this.stats.getAvgSizeinBytes(Tracked.PUT);
    }
}

