/*
 * Decompiled with CFR 0.152.
 */
package voldemort.utils;

import java.io.IOException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import voldemort.VoldemortException;

public class SelectorManager
implements Runnable {
    public static final int SELECTOR_POLL_MS = 500;
    protected final Selector selector;
    protected final AtomicBoolean isClosed;
    protected final Logger logger = Logger.getLogger(this.getClass());

    public SelectorManager() {
        try {
            this.selector = Selector.open();
        }
        catch (IOException e) {
            throw new VoldemortException(e);
        }
        this.isClosed = new AtomicBoolean(false);
    }

    public void close() {
        block14: {
            block13: {
                if (!this.isClosed.compareAndSet(false, true)) {
                    return;
                }
                try {
                    for (SelectionKey sk : this.selector.keys()) {
                        block12: {
                            try {
                                if (this.logger.isTraceEnabled()) {
                                    this.logger.trace((Object)"Closing SelectionKey's channel");
                                }
                                sk.channel().close();
                            }
                            catch (Exception e) {
                                if (!this.logger.isEnabledFor((Priority)Level.WARN)) break block12;
                                this.logger.warn((Object)e.getMessage(), (Throwable)e);
                            }
                        }
                        try {
                            if (this.logger.isTraceEnabled()) {
                                this.logger.trace((Object)"Cancelling SelectionKey");
                            }
                            sk.cancel();
                        }
                        catch (Exception e) {
                            if (!this.logger.isEnabledFor((Priority)Level.WARN)) continue;
                            this.logger.warn((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                }
                catch (Exception e) {
                    if (!this.logger.isEnabledFor((Priority)Level.WARN)) break block13;
                    this.logger.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
            try {
                this.selector.close();
            }
            catch (Exception e) {
                if (!this.logger.isEnabledFor((Priority)Level.WARN)) break block14;
                this.logger.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void processEvents() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block11: while (true) {
            try {
                try {}
                catch (Throwable t) {
                    if (this.logger.isEnabledFor((Priority)Level.ERROR)) {
                        this.logger.error((Object)t.getMessage(), t);
                    }
                    var6_9 = null;
                    try {
                        this.close();
                        return;
                    }
                    catch (Exception e) {
                        if (this.logger.isEnabledFor((Priority)Level.ERROR) == false) return;
                        this.logger.error((Object)e.getMessage(), (Throwable)e);
                        return;
                    }
                }
            }
            catch (Throwable var5_14) {
                var6_10 = null;
                ** try [egrp 3[TRYBLOCK] [8 : 264->271)] { 
lbl21:
                // 1 sources

                this.close();
                throw var5_14;
lbl23:
                // 1 sources

                catch (Exception e) {
                    if (this.logger.isEnabledFor((Priority)Level.ERROR) == false) throw var5_14;
                    this.logger.error((Object)e.getMessage(), (Throwable)e);
                }
                throw var5_14;
            }
            while (true) {
                if (this.isClosed.get()) {
                    if (!this.logger.isInfoEnabled()) break block11;
                    this.logger.info((Object)"Closed, exiting");
                    break block11;
                }
                this.processEvents();
                try {
                    selected = this.selector.select(500L);
                    if (this.isClosed.get()) {
                        if (!this.logger.isInfoEnabled()) break block11;
                        this.logger.info((Object)"Closed, exiting");
                        break block11;
                    }
                    if (selected <= 0) continue block11;
                    i = this.selector.selectedKeys().iterator();
                    while (true) {
                        if (i.hasNext()) ** break;
                        continue block11;
                        selectionKey = i.next();
                        i.remove();
                        if (!selectionKey.isValid() || !selectionKey.isReadable() && !selectionKey.isWritable()) continue;
                        worker = (Runnable)selectionKey.attachment();
                        worker.run();
                    }
                }
                catch (ClosedSelectorException e) {
                    if (!this.logger.isDebugEnabled()) break block11;
                    this.logger.debug((Object)"Selector is closed, exiting");
                    break block11;
                }
                catch (Throwable t) {
                    if (!this.logger.isEnabledFor((Priority)Level.ERROR)) continue;
                    this.logger.error((Object)t.getMessage(), t);
                    continue;
                }
                break;
            }
            break;
        }
        var6_8 = null;
        try {}
        catch (Exception e) {
            if (this.logger.isEnabledFor((Priority)Level.ERROR) == false) return;
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            return;
        }
        this.close();
    }
}

