/*
 * Decompiled with CFR 0.152.
 */
package voldemort.versioning;

import java.util.ArrayList;
import java.util.List;
import voldemort.utils.Utils;
import voldemort.versioning.InconsistencyResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainedResolver<T>
implements InconsistencyResolver<T> {
    private List<InconsistencyResolver<T>> resolvers;

    public ChainedResolver(InconsistencyResolver<T> ... resolvers) {
        this.resolvers = new ArrayList<InconsistencyResolver<T>>(resolvers.length);
        for (InconsistencyResolver<T> resolver : resolvers) {
            this.resolvers.add(Utils.notNull(resolver));
        }
    }

    @Override
    public List<T> resolveConflicts(List<T> items) {
        for (InconsistencyResolver<T> resolver : this.resolvers) {
            if (items.size() <= 1) {
                return items;
            }
            items = resolver.resolveConflicts(items);
        }
        return items;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChainedResolver that = (ChainedResolver)o;
        return !(this.resolvers != null ? !((Object)this.resolvers).equals(that.resolvers) : that.resolvers != null);
    }

    public int hashCode() {
        return this.resolvers != null ? ((Object)this.resolvers).hashCode() : 0;
    }
}

