/*
 * Decompiled with CFR 0.152.
 */
package azkaban.execapp.event;

import azkaban.executor.Status;

public class BlockingStatus {
    private static final long WAIT_TIME = 300000L;
    private final int execId;
    private final String jobId;
    private Status status;

    public BlockingStatus(int execId, String jobId, Status initialStatus) {
        this.execId = execId;
        this.jobId = jobId;
        this.status = initialStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status blockOnFinishedStatus() {
        if (this.status == null) {
            return null;
        }
        while (!Status.isStatusFinished(this.status)) {
            BlockingStatus blockingStatus = this;
            synchronized (blockingStatus) {
                try {
                    this.wait(300000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return this.status;
    }

    public Status viewStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unblock() {
        BlockingStatus blockingStatus = this;
        synchronized (blockingStatus) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeStatus(Status status) {
        BlockingStatus blockingStatus = this;
        synchronized (blockingStatus) {
            this.status = status;
            if (Status.isStatusFinished(status)) {
                this.unblock();
            }
        }
    }

    public int getExecId() {
        return this.execId;
    }

    public String getJobId() {
        return this.jobId;
    }
}

