/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskAttemptID;

public class Job
extends JobContext {
    private JobState state = JobState.DEFINE;
    private JobClient jobClient;
    private RunningJob info;

    public Job() throws IOException {
        this(new Configuration());
    }

    public Job(Configuration conf) throws IOException {
        super(conf, null);
    }

    public Job(Configuration conf, String jobName) throws IOException {
        this(conf);
        this.setJobName(jobName);
    }

    JobClient getJobClient() {
        return this.jobClient;
    }

    private void ensureState(JobState state) throws IllegalStateException {
        if (state != this.state) {
            throw new IllegalStateException("Job in state " + (Object)((Object)this.state) + " instead of " + (Object)((Object)state));
        }
        if (state == JobState.RUNNING && this.jobClient == null) {
            throw new IllegalStateException("Job in state " + (Object)((Object)JobState.RUNNING) + " however jobClient is not initialized!");
        }
    }

    public void setNumReduceTasks(int tasks) throws IllegalStateException {
        this.ensureState(JobState.DEFINE);
        this.conf.setNumReduceTasks(tasks);
    }

    public void setWorkingDirectory(Path dir) throws IOException {
        this.ensureState(JobState.DEFINE);
        this.conf.setWorkingDirectory(dir);
    }

    public void setInputFormatClass(Class<? extends InputFormat> cls) throws IllegalStateException {
        this.ensureState(JobState.DEFINE);
        this.conf.setClass("mapreduce.inputformat.class", cls, InputFormat.class);
    }

    public void setOutputFormatClass(Class<? extends OutputFormat> cls) throws IllegalStateException {
        this.ensureState(JobState.DEFINE);
        this.conf.setClass("mapreduce.outputformat.class", cls, OutputFormat.class);
    }

    public void setMapperClass(Class<? extends Mapper> cls) throws IllegalStateException {
        this.ensureState(JobState.DEFINE);
        this.conf.setClass("mapreduce.map.class", cls, Mapper.class);
    }

    public void setJarByClass(Class<?> cls) {
        this.conf.setJarByClass(cls);
    }

    @Override
    public String getJar() {
        return this.conf.getJar();
    }

    public void setCombinerClass(Class<? extends Reducer> cls) throws IllegalStateException {
        this.ensureState(JobState.DEFINE);
        this.conf.setClass("mapreduce.combine.class", cls, Reducer.class);
    }

    public void setReducerClass(Class<? extends Reducer> cls) throws IllegalStateException {
        this.ensureState(JobState.DEFINE);
        this.conf.setClass("mapreduce.reduce.class", cls, Reducer.class);
    }

    public void setPartitionerClass(Class<? extends Partitioner> cls) throws IllegalStateException {
        this.ensureState(JobState.DEFINE);
        this.conf.setClass("mapreduce.partitioner.class", cls, Partitioner.class);
    }

    public void setMapOutputKeyClass(Class<?> theClass) throws IllegalStateException {
        this.ensureState(JobState.DEFINE);
        this.conf.setMapOutputKeyClass(theClass);
    }

    public void setMapOutputValueClass(Class<?> theClass) throws IllegalStateException {
        this.ensureState(JobState.DEFINE);
        this.conf.setMapOutputValueClass(theClass);
    }

    public void setOutputKeyClass(Class<?> theClass) throws IllegalStateException {
        this.ensureState(JobState.DEFINE);
        this.conf.setOutputKeyClass(theClass);
    }

    public void setOutputValueClass(Class<?> theClass) throws IllegalStateException {
        this.ensureState(JobState.DEFINE);
        this.conf.setOutputValueClass(theClass);
    }

    public void setSortComparatorClass(Class<? extends RawComparator> cls) throws IllegalStateException {
        this.ensureState(JobState.DEFINE);
        this.conf.setOutputKeyComparatorClass(cls);
    }

    public void setGroupingComparatorClass(Class<? extends RawComparator> cls) throws IllegalStateException {
        this.ensureState(JobState.DEFINE);
        this.conf.setOutputValueGroupingComparator(cls);
    }

    public void setJobName(String name) throws IllegalStateException {
        this.ensureState(JobState.DEFINE);
        this.conf.setJobName(name);
    }

    public void setSpeculativeExecution(boolean speculativeExecution) {
        this.ensureState(JobState.DEFINE);
        this.conf.setSpeculativeExecution(speculativeExecution);
    }

    public void setMapSpeculativeExecution(boolean speculativeExecution) {
        this.ensureState(JobState.DEFINE);
        this.conf.setMapSpeculativeExecution(speculativeExecution);
    }

    public void setReduceSpeculativeExecution(boolean speculativeExecution) {
        this.ensureState(JobState.DEFINE);
        this.conf.setReduceSpeculativeExecution(speculativeExecution);
    }

    public String getTrackingURL() {
        this.ensureState(JobState.RUNNING);
        return this.info.getTrackingURL();
    }

    public float setupProgress() throws IOException {
        this.ensureState(JobState.RUNNING);
        return this.info.setupProgress();
    }

    public float mapProgress() throws IOException {
        this.ensureState(JobState.RUNNING);
        return this.info.mapProgress();
    }

    public float reduceProgress() throws IOException {
        this.ensureState(JobState.RUNNING);
        return this.info.reduceProgress();
    }

    public boolean isComplete() throws IOException {
        this.ensureState(JobState.RUNNING);
        return this.info.isComplete();
    }

    public boolean isSuccessful() throws IOException {
        this.ensureState(JobState.RUNNING);
        return this.info.isSuccessful();
    }

    public void killJob() throws IOException {
        this.ensureState(JobState.RUNNING);
        this.info.killJob();
    }

    public TaskCompletionEvent[] getTaskCompletionEvents(int startFrom) throws IOException {
        this.ensureState(JobState.RUNNING);
        return this.info.getTaskCompletionEvents(startFrom);
    }

    public void killTask(TaskAttemptID taskId) throws IOException {
        this.ensureState(JobState.RUNNING);
        this.info.killTask(org.apache.hadoop.mapred.TaskAttemptID.downgrade(taskId), false);
    }

    public void failTask(TaskAttemptID taskId) throws IOException {
        this.ensureState(JobState.RUNNING);
        this.info.killTask(org.apache.hadoop.mapred.TaskAttemptID.downgrade(taskId), true);
    }

    public Counters getCounters() throws IOException {
        this.ensureState(JobState.RUNNING);
        return new Counters(this.info.getCounters());
    }

    private void ensureNotSet(String attr, String msg) throws IOException {
        if (this.conf.get(attr) != null) {
            throw new IOException(attr + " is incompatible with " + msg + " mode.");
        }
    }

    public void setCancelDelegationTokenUponJobCompletion(boolean value) {
        this.ensureState(JobState.DEFINE);
        this.conf.setBoolean("mapreduce.job.complete.cancel.delegation.tokens", value);
    }

    private void setUseNewAPI() throws IOException {
        String mode;
        int numReduces = this.conf.getNumReduceTasks();
        String oldMapperClass = "mapred.mapper.class";
        String oldReduceClass = "mapred.reducer.class";
        this.conf.setBooleanIfUnset("mapred.mapper.new-api", this.conf.get(oldMapperClass) == null);
        if (this.conf.getUseNewMapper()) {
            mode = "new map API";
            this.ensureNotSet("mapred.input.format.class", mode);
            this.ensureNotSet(oldMapperClass, mode);
            if (numReduces != 0) {
                this.ensureNotSet("mapred.partitioner.class", mode);
            } else {
                this.ensureNotSet("mapred.output.format.class", mode);
            }
        } else {
            mode = "map compatability";
            this.ensureNotSet("mapreduce.inputformat.class", mode);
            this.ensureNotSet("mapreduce.map.class", mode);
            if (numReduces != 0) {
                this.ensureNotSet("mapreduce.partitioner.class", mode);
            } else {
                this.ensureNotSet("mapreduce.outputformat.class", mode);
            }
        }
        if (numReduces != 0) {
            this.conf.setBooleanIfUnset("mapred.reducer.new-api", this.conf.get(oldReduceClass) == null);
            if (this.conf.getUseNewReducer()) {
                mode = "new reduce API";
                this.ensureNotSet("mapred.output.format.class", mode);
                this.ensureNotSet(oldReduceClass, mode);
            } else {
                mode = "reduce compatability";
                this.ensureNotSet("mapreduce.outputformat.class", mode);
                this.ensureNotSet("mapreduce.reduce.class", mode);
            }
        }
    }

    public void submit() throws IOException, InterruptedException, ClassNotFoundException {
        this.ensureState(JobState.DEFINE);
        this.setUseNewAPI();
        this.connect();
        this.info = this.jobClient.submitJobInternal(this.conf);
        super.setJobID(this.info.getID());
        this.state = JobState.RUNNING;
    }

    private void connect() throws IOException, InterruptedException {
        this.ugi.doAs(new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws IOException {
                Job.this.jobClient = new JobClient((JobConf)Job.this.getConfiguration());
                return null;
            }
        });
    }

    public boolean waitForCompletion(boolean verbose) throws IOException, InterruptedException, ClassNotFoundException {
        if (this.state == JobState.DEFINE) {
            this.submit();
        }
        if (verbose) {
            this.jobClient.monitorAndPrintJob(this.conf, this.info);
        } else {
            this.info.waitForCompletion();
        }
        return this.isSuccessful();
    }

    public static enum JobState {
        DEFINE,
        RUNNING;

    }
}

