/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pig.EvalFunc;
import org.apache.pig.FuncSpec;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.builtin.BagSize;
import org.apache.pig.builtin.ConstantSize;
import org.apache.pig.builtin.MapSize;
import org.apache.pig.builtin.StringSize;
import org.apache.pig.builtin.TupleSize;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SIZE
extends EvalFunc<Long> {
    @Override
    public Long exec(Tuple input) throws IOException {
        try {
            DataByteArray dba = (DataByteArray)input.get(0);
            return dba == null ? null : Long.valueOf(dba.size());
        }
        catch (ExecException exp) {
            throw exp;
        }
        catch (Exception e) {
            int errCode = 2106;
            String msg = "Error while computing size in " + this.getClass().getSimpleName();
            throw new ExecException(msg, errCode, 4, e);
        }
    }

    @Override
    public Schema outputSchema(Schema input) {
        return new Schema(new Schema.FieldSchema(null, 15));
    }

    @Override
    public List<FuncSpec> getArgToFuncMapping() throws FrontendException {
        ArrayList<FuncSpec> funcList = new ArrayList<FuncSpec>();
        Schema s = new Schema();
        s.add(new Schema.FieldSchema(null, 50));
        funcList.add(new FuncSpec(this.getClass().getName(), s));
        s = new Schema();
        s.add(new Schema.FieldSchema(null, 55));
        funcList.add(new FuncSpec(StringSize.class.getName(), s));
        s = new Schema();
        s.add(new Schema.FieldSchema(null, 110));
        funcList.add(new FuncSpec(TupleSize.class.getName(), s));
        s = new Schema();
        s.add(new Schema.FieldSchema(null, 120));
        funcList.add(new FuncSpec(BagSize.class.getName(), s));
        s = new Schema();
        s.add(new Schema.FieldSchema(null, 100));
        funcList.add(new FuncSpec(MapSize.class.getName(), s));
        s = new Schema();
        s.add(new Schema.FieldSchema(null, 10));
        funcList.add(new FuncSpec(ConstantSize.class.getName(), s));
        s = new Schema();
        s.add(new Schema.FieldSchema(null, 15));
        funcList.add(new FuncSpec(ConstantSize.class.getName(), s));
        s = new Schema();
        s.add(new Schema.FieldSchema(null, 20));
        funcList.add(new FuncSpec(ConstantSize.class.getName(), s));
        s = new Schema();
        s.add(new Schema.FieldSchema(null, 25));
        funcList.add(new FuncSpec(ConstantSize.class.getName(), s));
        return funcList;
    }
}

