/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.streaming;

import java.util.List;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.impl.streaming.DefaultInputHandler;
import org.apache.pig.impl.streaming.DefaultOutputHandler;
import org.apache.pig.impl.streaming.FileInputHandler;
import org.apache.pig.impl.streaming.FileOutputHandler;
import org.apache.pig.impl.streaming.InputHandler;
import org.apache.pig.impl.streaming.OutputHandler;
import org.apache.pig.impl.streaming.StreamingCommand;

public class HandlerFactory {
    public static InputHandler createInputHandler(StreamingCommand command) throws ExecException {
        List<StreamingCommand.HandleSpec> inputSpecs = command.getHandleSpecs(StreamingCommand.Handle.INPUT);
        StreamingCommand.HandleSpec in = null;
        if (inputSpecs == null || (in = inputSpecs.get(0)) == null) {
            return new DefaultInputHandler();
        }
        return in.name.equals("stdin") ? new DefaultInputHandler(in) : new FileInputHandler(in);
    }

    public static OutputHandler createOutputHandler(StreamingCommand command) throws ExecException {
        List<StreamingCommand.HandleSpec> outputSpecs = command.getHandleSpecs(StreamingCommand.Handle.OUTPUT);
        StreamingCommand.HandleSpec out = null;
        if (outputSpecs == null || (out = outputSpecs.get(0)) == null) {
            return new DefaultOutputHandler();
        }
        return out.name.equals("stdout") ? new DefaultOutputHandler(out) : new FileOutputHandler(out);
    }
}

