/*
 * Decompiled with CFR 0.152.
 */
package voldemort.client.rebalance;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import voldemort.VoldemortException;
import voldemort.cluster.Cluster;
import voldemort.serialization.json.JsonReader;
import voldemort.serialization.json.JsonWriter;
import voldemort.utils.Utils;
import voldemort.xml.ClusterMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RebalancePartitionsInfo {
    private final int stealerId;
    private final int donorId;
    private int attempt;
    private HashMap<String, HashMap<Integer, List<Integer>>> storeToReplicaToAddPartitionList;
    private HashMap<String, HashMap<Integer, List<Integer>>> storeToReplicaToDeletePartitionList;
    private int maxReplica;
    private Cluster initialCluster;

    public RebalancePartitionsInfo(int stealerNodeId, int donorId, HashMap<String, HashMap<Integer, List<Integer>>> storeToReplicaToAddPartitionList, HashMap<String, HashMap<Integer, List<Integer>>> storeToReplicaToDeletePartitionList, Cluster initialCluster, int attempt) {
        this.stealerId = stealerNodeId;
        this.donorId = donorId;
        this.storeToReplicaToAddPartitionList = storeToReplicaToAddPartitionList;
        this.storeToReplicaToDeletePartitionList = storeToReplicaToDeletePartitionList;
        if (!storeToReplicaToAddPartitionList.keySet().containsAll(storeToReplicaToDeletePartitionList.keySet())) {
            throw new VoldemortException("Some stores are marked for deletion but are not in the addition list");
        }
        this.attempt = attempt;
        this.maxReplica = 0;
        this.findMaxReplicaType(storeToReplicaToAddPartitionList);
        this.findMaxReplicaType(storeToReplicaToDeletePartitionList);
        this.initialCluster = Utils.notNull(initialCluster);
    }

    private void findMaxReplicaType(HashMap<String, HashMap<Integer, List<Integer>>> storeToReplicaToPartitionList) {
        for (Map.Entry<String, HashMap<Integer, List<Integer>>> entry : storeToReplicaToPartitionList.entrySet()) {
            for (Map.Entry<Integer, List<Integer>> replicaToPartitionList : entry.getValue().entrySet()) {
                if (replicaToPartitionList.getKey() <= this.maxReplica) continue;
                this.maxReplica = replicaToPartitionList.getKey();
            }
        }
    }

    public static RebalancePartitionsInfo create(String line) {
        try {
            JsonReader reader = new JsonReader(new StringReader(line));
            Map<String, ?> map = reader.readObject();
            return RebalancePartitionsInfo.create(map);
        }
        catch (Exception e) {
            throw new VoldemortException("Failed to create partition info from string: " + line, e);
        }
    }

    public static RebalancePartitionsInfo create(Map<?, ?> map) {
        int stealerId = (Integer)map.get("stealerId");
        int donorId = (Integer)map.get("donorId");
        List unbalancedStoreList = (List)Utils.uncheckedCast(map.get("unbalancedStores"));
        int attempt = (Integer)map.get("attempt");
        int maxReplicas = (Integer)map.get("maxReplicas");
        Cluster initialCluster = new ClusterMapper().readCluster(new StringReader((String)map.get("initialCluster")));
        HashMap storeToReplicaToAddPartition = Maps.newHashMap();
        HashMap storeToReplicaToDeletePartition = Maps.newHashMap();
        for (String unbalancedStore : unbalancedStoreList) {
            HashMap replicaToAddPartition = Maps.newHashMap();
            HashMap replicaToDeletePartitionList = Maps.newHashMap();
            for (int replicaNo = 0; replicaNo <= maxReplicas; ++replicaNo) {
                List deletePartitionList;
                List partitionList = (List)Utils.uncheckedCast(map.get(unbalancedStore + "replicaToAddPartitionList" + Integer.toString(replicaNo)));
                if (partitionList.size() > 0) {
                    replicaToAddPartition.put(replicaNo, partitionList);
                }
                if ((deletePartitionList = (List)Utils.uncheckedCast(map.get(unbalancedStore + "replicaToDeletePartitionList" + Integer.toString(replicaNo)))).size() <= 0) continue;
                replicaToDeletePartitionList.put(replicaNo, deletePartitionList);
            }
            if (replicaToAddPartition.size() > 0) {
                storeToReplicaToAddPartition.put(unbalancedStore, replicaToAddPartition);
            }
            if (replicaToDeletePartitionList.size() <= 0) continue;
            storeToReplicaToDeletePartition.put(unbalancedStore, replicaToDeletePartitionList);
        }
        return new RebalancePartitionsInfo(stealerId, donorId, storeToReplicaToAddPartition, storeToReplicaToDeletePartition, initialCluster, attempt);
    }

    public ImmutableMap<String, Object> asMap() {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        builder.put((Object)"stealerId", (Object)this.stealerId).put((Object)"donorId", (Object)this.donorId).put((Object)"unbalancedStores", (Object)Lists.newArrayList(this.storeToReplicaToAddPartitionList.keySet())).put((Object)"attempt", (Object)this.attempt).put((Object)"maxReplicas", (Object)this.maxReplica).put((Object)"initialCluster", (Object)new ClusterMapper().writeCluster(this.initialCluster));
        for (String unbalancedStore : this.storeToReplicaToAddPartitionList.keySet()) {
            HashMap<Integer, List<Integer>> replicaToAddPartition = this.storeToReplicaToAddPartitionList.get(unbalancedStore);
            HashMap<Integer, List<Integer>> replicaToDeletePartition = this.storeToReplicaToDeletePartitionList.get(unbalancedStore);
            for (int replicaNum = 0; replicaNum <= this.maxReplica; ++replicaNum) {
                if (replicaToAddPartition != null && replicaToAddPartition.containsKey(replicaNum)) {
                    builder.put((Object)(unbalancedStore + "replicaToAddPartitionList" + Integer.toString(replicaNum)), replicaToAddPartition.get(replicaNum));
                } else {
                    builder.put((Object)(unbalancedStore + "replicaToAddPartitionList" + Integer.toString(replicaNum)), (Object)Lists.newArrayList());
                }
                if (replicaToDeletePartition != null && replicaToDeletePartition.containsKey(replicaNum)) {
                    builder.put((Object)(unbalancedStore + "replicaToDeletePartitionList" + Integer.toString(replicaNum)), replicaToDeletePartition.get(replicaNum));
                    continue;
                }
                builder.put((Object)(unbalancedStore + "replicaToDeletePartitionList" + Integer.toString(replicaNum)), (Object)Lists.newArrayList());
            }
        }
        return builder.build();
    }

    public void setAttempt(int attempt) {
        this.attempt = attempt;
    }

    public int getDonorId() {
        return this.donorId;
    }

    public int getAttempt() {
        return this.attempt;
    }

    public int getStealerId() {
        return this.stealerId;
    }

    public Cluster getInitialCluster() {
        return this.initialCluster;
    }

    public Set<String> getUnbalancedStoreList() {
        return this.storeToReplicaToAddPartitionList.keySet();
    }

    public HashMap<String, HashMap<Integer, List<Integer>>> getStoreToReplicaToAddPartitionList() {
        return this.storeToReplicaToAddPartitionList;
    }

    public HashMap<String, HashMap<Integer, List<Integer>>> getStoreToReplicaToDeletePartitionList() {
        return this.storeToReplicaToDeletePartitionList;
    }

    public HashMap<Integer, List<Integer>> getReplicaToAddPartitionList(String storeName) {
        return this.storeToReplicaToAddPartitionList.get(storeName);
    }

    public HashMap<Integer, List<Integer>> getReplicaToDeletePartitionList(String storeName) {
        return this.storeToReplicaToDeletePartitionList.get(storeName);
    }

    public void setStoreToReplicaToAddPartitionList(HashMap<String, HashMap<Integer, List<Integer>>> storeToReplicaToAddPartitionList) {
        this.storeToReplicaToAddPartitionList = storeToReplicaToAddPartitionList;
    }

    public void setStoreToReplicaToDeletePartitionList(HashMap<String, HashMap<Integer, List<Integer>>> storeToReplicaToDeletePartitionList) {
        this.storeToReplicaToDeletePartitionList = storeToReplicaToDeletePartitionList;
    }

    public void removeStore(String storeName) {
        this.storeToReplicaToAddPartitionList.remove(storeName);
        this.storeToReplicaToDeletePartitionList.remove(storeName);
    }

    public List<Integer> getStealMasterPartitions() {
        Iterator<HashMap<Integer, List<Integer>>> iter = this.storeToReplicaToAddPartitionList.values().iterator();
        ArrayList primaryPartitionsBeingMoved = Lists.newArrayList();
        while (iter.hasNext()) {
            HashMap<Integer, List<Integer>> partitionTuples = iter.next();
            if (!partitionTuples.containsKey(0)) continue;
            primaryPartitionsBeingMoved.addAll((Collection)partitionTuples.get(0));
        }
        return primaryPartitionsBeingMoved;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\nRebalancePartitionsInfo(" + this.getStealerId() + " <--- " + this.getDonorId() + " ");
        for (String unbalancedStore : this.storeToReplicaToAddPartitionList.keySet()) {
            int replicaNum;
            sb.append("\n\t- Store '" + unbalancedStore + "' move ");
            HashMap<Integer, List<Integer>> replicaToAddPartition = this.storeToReplicaToAddPartitionList.get(unbalancedStore);
            HashMap<Integer, List<Integer>> replicaToDeletePartition = this.storeToReplicaToDeletePartitionList.get(unbalancedStore);
            for (replicaNum = 0; replicaNum <= this.maxReplica; ++replicaNum) {
                if (replicaToAddPartition != null && replicaToAddPartition.containsKey(replicaNum)) {
                    sb.append(" - " + replicaToAddPartition.get(replicaNum));
                    continue;
                }
                sb.append(" - []");
            }
            sb.append(", delete ");
            for (replicaNum = 0; replicaNum <= this.maxReplica; ++replicaNum) {
                if (replicaToDeletePartition != null && replicaToDeletePartition.containsKey(replicaNum)) {
                    sb.append(" - " + replicaToDeletePartition.get(replicaNum));
                    continue;
                }
                sb.append(" - []");
            }
        }
        sb.append(")");
        return sb.toString();
    }

    public String toJsonString() {
        ImmutableMap<String, Object> map = this.asMap();
        StringWriter writer = new StringWriter();
        new JsonWriter(writer).write(map);
        writer.flush();
        return writer.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RebalancePartitionsInfo that = (RebalancePartitionsInfo)o;
        if (this.attempt != that.attempt) {
            return false;
        }
        if (this.donorId != that.donorId) {
            return false;
        }
        if (this.stealerId != that.stealerId) {
            return false;
        }
        if (!this.initialCluster.equals(that.initialCluster)) {
            return false;
        }
        if (this.storeToReplicaToAddPartitionList != null ? !this.storeToReplicaToAddPartitionList.equals(that.storeToReplicaToAddPartitionList) : that.storeToReplicaToAddPartitionList != null) {
            return false;
        }
        return !(this.storeToReplicaToDeletePartitionList != null ? !this.storeToReplicaToDeletePartitionList.equals(that.storeToReplicaToDeletePartitionList) : that.storeToReplicaToDeletePartitionList != null);
    }

    public int hashCode() {
        int result = this.stealerId;
        result = 31 * result + this.donorId;
        result = 31 * result + this.initialCluster.hashCode();
        result = 31 * result + (this.storeToReplicaToAddPartitionList != null ? this.storeToReplicaToAddPartitionList.hashCode() : 0);
        result = 31 * result + (this.storeToReplicaToDeletePartitionList != null ? this.storeToReplicaToDeletePartitionList.hashCode() : 0);
        result = 31 * result + this.attempt;
        return result;
    }
}

