/*
 * Decompiled with CFR 0.152.
 */
package voldemort.server.protocol.admin;

import com.google.protobuf.Message;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import voldemort.client.protocol.pb.ProtoUtils;
import voldemort.client.protocol.pb.VAdminProto;
import voldemort.server.StoreRepository;
import voldemort.server.VoldemortConfig;
import voldemort.server.protocol.StreamRequestHandler;
import voldemort.server.protocol.admin.FetchStreamRequestHandler;
import voldemort.store.ErrorCodeMapper;
import voldemort.store.metadata.MetadataStore;
import voldemort.store.stats.StreamStats;
import voldemort.utils.ByteArray;
import voldemort.utils.NetworkClassLoader;
import voldemort.utils.RebalanceUtils;

public class FetchKeysStreamRequestHandler
extends FetchStreamRequestHandler {
    public FetchKeysStreamRequestHandler(VAdminProto.FetchPartitionEntriesRequest request, MetadataStore metadataStore, ErrorCodeMapper errorCodeMapper, VoldemortConfig voldemortConfig, StoreRepository storeRepository, NetworkClassLoader networkClassLoader, StreamStats stats) {
        super(request, metadataStore, errorCodeMapper, voldemortConfig, storeRepository, networkClassLoader, stats, StreamStats.Operation.FETCH_KEYS);
        this.logger.info((Object)("Starting fetch keys for store '" + this.storageEngine.getName() + "' with replica to partition mapping " + this.replicaToPartitionList));
    }

    public StreamRequestHandler.StreamRequestHandlerState handleRequest(DataInputStream inputStream, DataOutputStream outputStream) throws IOException {
        if (!this.keyIterator.hasNext()) {
            return StreamRequestHandler.StreamRequestHandlerState.COMPLETE;
        }
        long startNs = System.nanoTime();
        ByteArray key = (ByteArray)this.keyIterator.next();
        this.stats.recordDiskTime(this.handle, System.nanoTime() - startNs);
        this.throttler.maybeThrottle(key.length());
        if (RebalanceUtils.checkKeyBelongsToPartition(this.nodeId, key.get(), this.replicaToPartitionList, this.initialCluster, this.storeDef) && this.filter.accept(key, null) && this.counter % this.skipRecords == 0L) {
            VAdminProto.FetchPartitionEntriesResponse.Builder response = VAdminProto.FetchPartitionEntriesResponse.newBuilder();
            response.setKey(ProtoUtils.encodeBytes(key));
            ++this.fetched;
            this.handle.incrementEntriesScanned();
            VAdminProto.FetchPartitionEntriesResponse message = response.build();
            startNs = System.nanoTime();
            ProtoUtils.writeMessage(outputStream, (Message)message);
            this.stats.recordNetworkTime(this.handle, System.nanoTime() - startNs);
        }
        ++this.counter;
        if (0L == this.counter % 100000L) {
            long totalTime = (System.currentTimeMillis() - this.startTime) / 1000L;
            this.logger.info((Object)("Fetch keys scanned " + this.counter + " keys, fetched " + this.fetched + " keys for store '" + this.storageEngine.getName() + "' replicaToPartitionList:" + this.replicaToPartitionList + " in " + totalTime + " s"));
        }
        if (this.keyIterator.hasNext()) {
            return StreamRequestHandler.StreamRequestHandlerState.WRITING;
        }
        this.stats.closeHandle(this.handle);
        return StreamRequestHandler.StreamRequestHandlerState.COMPLETE;
    }
}

