/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import voldemort.VoldemortException;
import voldemort.cluster.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InsufficientOperationalNodesException
extends VoldemortException {
    private static final long serialVersionUID = 1L;
    private Collection<? extends Throwable> causes;
    private static final Logger logger = Logger.getLogger(InsufficientOperationalNodesException.class);

    public InsufficientOperationalNodesException(String s, Throwable e) {
        super(s, e);
        this.causes = Collections.singleton(e);
    }

    public InsufficientOperationalNodesException(String s) {
        super(s);
        this.causes = Collections.emptyList();
    }

    public InsufficientOperationalNodesException(Throwable e) {
        super(e);
        this.causes = Collections.singleton(e);
    }

    public InsufficientOperationalNodesException(Collection<? extends Throwable> failures) {
        this("Insufficient operational nodes to immediately satisfy request.", failures);
    }

    public InsufficientOperationalNodesException(String message, Collection<? extends Throwable> failures) {
        super(message, failures.size() > 0 ? failures.iterator().next() : null);
        this.causes = failures;
    }

    public InsufficientOperationalNodesException(String message, List<Node> replicationSet, List<Node> preferenceList, List<Node> failedList, Collection<? extends Throwable> failures) {
        this(message + " Original replication set :" + InsufficientOperationalNodesException.stripNodeIds(replicationSet) + " Known failed nodes before operation :" + InsufficientOperationalNodesException.stripNodeIds(InsufficientOperationalNodesException.difference(replicationSet, preferenceList)) + " Estimated live nodes in preference list :" + InsufficientOperationalNodesException.stripNodeIds(preferenceList) + " New failed nodes during operation :" + InsufficientOperationalNodesException.stripNodeIds(InsufficientOperationalNodesException.difference(failedList, replicationSet)), failures.size() > 0 ? failures.iterator().next() : null);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)this.getMessage());
        }
    }

    public Collection<? extends Throwable> getCauses() {
        return this.causes;
    }

    private static List<Integer> stripNodeIds(List<Node> nodeList) {
        ArrayList<Integer> nodeidList = new ArrayList<Integer>();
        if (nodeList != null) {
            for (Node node : nodeList) {
                nodeidList.add(node.getId());
            }
        }
        return nodeidList;
    }

    private static List<Node> difference(List<Node> listA, List<Node> listB) {
        if (listA != null && listB != null) {
            listA.removeAll(listB);
        }
        return listA;
    }
}

