/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.socket.clientrequest;

import java.util.concurrent.TimeUnit;
import voldemort.VoldemortException;
import voldemort.client.protocol.RequestFormatType;
import voldemort.server.RequestRoutingType;
import voldemort.store.UnreachableStoreException;
import voldemort.store.socket.SocketDestination;
import voldemort.store.socket.SocketStore;
import voldemort.store.socket.SocketStoreFactory;
import voldemort.store.socket.clientrequest.ClientRequestExecutor;
import voldemort.store.socket.clientrequest.ClientRequestExecutorFactory;
import voldemort.store.stats.ClientSocketStats;
import voldemort.store.stats.ClientSocketStatsJmx;
import voldemort.utils.JmxUtils;
import voldemort.utils.Utils;
import voldemort.utils.pool.KeyedResourcePool;
import voldemort.utils.pool.ResourcePoolConfig;

public class ClientRequestExecutorPool
implements SocketStoreFactory {
    private final KeyedResourcePool<SocketDestination, ClientRequestExecutor> pool;
    private final ClientRequestExecutorFactory factory;
    private final ClientSocketStats stats;

    public ClientRequestExecutorPool(int selectors, int maxConnectionsPerNode, int connectionTimeoutMs, int soTimeoutMs, int socketBufferSize, boolean socketKeepAlive, boolean enableJmx) {
        ResourcePoolConfig config = new ResourcePoolConfig().setIsFair(true).setMaxPoolSize(maxConnectionsPerNode).setMaxInvalidAttempts(maxConnectionsPerNode).setTimeout(connectionTimeoutMs, TimeUnit.MILLISECONDS);
        if (enableJmx) {
            this.stats = new ClientSocketStats();
            JmxUtils.registerMbean(new ClientSocketStatsJmx(this.stats), JmxUtils.createObjectName(JmxUtils.getPackageName(this.getClass()), "aggregated"));
        } else {
            this.stats = null;
        }
        this.factory = new ClientRequestExecutorFactory(selectors, connectionTimeoutMs, soTimeoutMs, socketBufferSize, socketKeepAlive, this.stats);
        this.pool = new KeyedResourcePool<SocketDestination, ClientRequestExecutor>(this.factory, config);
        if (this.stats != null) {
            this.stats.setPool(this.pool);
        }
    }

    public ClientRequestExecutorPool(int selectors, int maxConnectionsPerNode, int connectionTimeoutMs, int soTimeoutMs, int socketBufferSize, boolean socketKeepAlive) {
        this(selectors, maxConnectionsPerNode, connectionTimeoutMs, soTimeoutMs, socketBufferSize, socketKeepAlive, false);
    }

    public ClientRequestExecutorPool(int maxConnectionsPerNode, int connectionTimeoutMs, int soTimeoutMs, int socketBufferSize) {
        this(2, maxConnectionsPerNode, connectionTimeoutMs, soTimeoutMs, socketBufferSize, false);
    }

    public ClientRequestExecutorFactory getFactory() {
        return this.factory;
    }

    public SocketStore create(String storeName, String hostName, int port, RequestFormatType requestFormatType, RequestRoutingType requestRoutingType) {
        SocketDestination dest = new SocketDestination(Utils.notNull(hostName), port, requestFormatType);
        return new SocketStore(Utils.notNull(storeName), this.factory.getTimeout(), dest, this, requestRoutingType);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ClientRequestExecutor checkout(SocketDestination destination) {
        ClientRequestExecutor clientRequestExecutor;
        long start = System.nanoTime();
        try {
            try {
                clientRequestExecutor = this.pool.checkout(destination);
            }
            catch (Exception e) {
                throw new UnreachableStoreException("Failure while checking out socket for " + destination + ": ", e);
            }
            Object var7_4 = null;
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            long end = System.nanoTime();
            if (this.stats == null) throw throwable;
            this.stats.recordCheckoutTimeUs(destination, (end - start) / 1000L);
            throw throwable;
        }
        long end = System.nanoTime();
        if (this.stats == null) return clientRequestExecutor;
        this.stats.recordCheckoutTimeUs(destination, (end - start) / 1000L);
        return clientRequestExecutor;
    }

    public void checkin(SocketDestination destination, ClientRequestExecutor clientRequestExecutor) {
        try {
            this.pool.checkin(destination, clientRequestExecutor);
        }
        catch (Exception e) {
            throw new VoldemortException("Failure while checking in socket for " + destination + ": ", e);
        }
    }

    public void close(SocketDestination destination) {
        this.factory.setLastClosedTimestamp(destination);
        this.pool.close(destination);
    }

    public void close() {
        if (this.stats != null) {
            try {
                JmxUtils.unregisterMbean(JmxUtils.createObjectName(JmxUtils.getPackageName(ClientRequestExecutor.class), "aggregated"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.stats.close();
        }
        this.factory.close();
        this.pool.close();
    }

    public ClientSocketStats getStats() {
        return this.stats;
    }
}

