/*
 * Decompiled with CFR 0.152.
 */
package voldemort.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import voldemort.annotations.concurrency.NotThreadsafe;
import voldemort.utils.ByteUtils;

@NotThreadsafe
public class ByteBufferBackedOutputStream
extends OutputStream {
    private ByteBuffer buffer;
    private boolean wasExpanded;

    public ByteBufferBackedOutputStream(ByteBuffer buffer) {
        this.buffer = buffer;
        this.wasExpanded = false;
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(ByteBuffer buffer) {
        this.buffer = buffer;
        this.wasExpanded = false;
    }

    public void write(int b) throws IOException {
        this.expandIfNeeded(1);
        this.buffer.put((byte)b);
    }

    public void write(byte[] bytes, int off, int len) throws IOException {
        this.expandIfNeeded(len);
        this.buffer.put(bytes, off, len);
    }

    private void expandIfNeeded(int len) {
        int need = len - this.buffer.remaining();
        if (need <= 0) {
            return;
        }
        int newCapacity = this.buffer.capacity() + need;
        this.buffer = ByteUtils.expand(this.buffer, newCapacity * 2);
        this.wasExpanded = true;
    }

    public boolean wasExpanded() {
        return this.wasExpanded;
    }
}

