/*
 * Decompiled with CFR 0.152.
 */
package voldemort.utils;

import com.sun.jna.Library;
import com.sun.jna.Native;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import voldemort.VoldemortException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static final String NEWLINE = System.getProperty("line.separator");
    public static final Pattern COMMA_SEP = Pattern.compile("\\s*,\\s*");

    public static void croak(String message) {
        System.err.println(message);
        System.exit(1);
    }

    public static void croak(String message, int errorCode) {
        System.err.println(message);
        System.exit(errorCode);
    }

    public static void rm(File file) {
        if (file != null) {
            Utils.rm(Collections.singletonList(file));
        }
    }

    public static void rm(File[] files) {
        if (files != null) {
            for (File f : files) {
                Utils.rm(f);
            }
        }
    }

    public static void rm(String file) {
        if (file != null) {
            Utils.rm(Collections.singletonList(new File(file)));
        }
    }

    public static void rm(Iterable<File> files) {
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    Utils.rm(Arrays.asList(f.listFiles()));
                    f.delete();
                    continue;
                }
                f.delete();
            }
        }
    }

    public static void symlink(String filePath, String symLinkPath) {
        File file = new File(filePath);
        File symLink = new File(symLinkPath);
        symLink.delete();
        if (!file.exists()) {
            throw new VoldemortException("File " + filePath + " does not exist");
        }
        Posix posix = (Posix)Native.loadLibrary((String)"c", Posix.class);
        int returnCode = posix.symlink(filePath, symLinkPath);
        if (returnCode < 0) {
            throw new VoldemortException("Unable to create symbolic link for " + filePath);
        }
    }

    public static void move(File source, File dest) {
        if (!source.exists()) {
            throw new VoldemortException("File " + source.toString() + " does not exist.");
        }
        Utils.rm(dest);
        boolean succeeded = source.renameTo(dest);
        if (!succeeded) {
            throw new VoldemortException("Rename of " + source + " to " + dest + " failed.");
        }
    }

    public static void mkdirs(File newDir) {
        if (newDir.exists()) {
            if (!newDir.canWrite() || !newDir.canRead()) {
                throw new VoldemortException("Unable to access directory " + newDir.getAbsolutePath());
            }
        } else if (!newDir.mkdirs()) {
            throw new VoldemortException("Unable to create directory " + newDir.getAbsolutePath());
        }
    }

    public static boolean isReadableFile(String fileName) {
        return Utils.isReadableFile(new File(fileName));
    }

    public static boolean isReadableFile(File f) {
        return f.exists() && f.isFile() && f.canRead();
    }

    public static boolean isReadableDir(String dirName) {
        return Utils.isReadableDir(new File(dirName));
    }

    public static boolean isReadableDir(File d) {
        return d.exists() && d.isDirectory() && d.canRead();
    }

    public static void assertNotNull(Object ... objects) {
        Utils.assertNotNull("Null argument not allowed", objects);
    }

    public static void assertNotNull(String s, Object ... objects) {
        for (Object o : objects) {
            if (o != null) continue;
            throw new IllegalArgumentException(s);
        }
    }

    public static <T> T notNull(T t, String message) {
        if (t == null) {
            throw new IllegalArgumentException(message);
        }
        return t;
    }

    public static <T> T notNull(T t) {
        if (t == null) {
            throw new IllegalArgumentException("This object MUST be non-null.");
        }
        return t;
    }

    public static int inRange(int value, int min, int max) {
        if (value < min) {
            throw new IllegalArgumentException("The value " + value + " is lower than the minimum value of " + min);
        }
        if (value > max) {
            throw new IllegalArgumentException("The value " + value + " is greater than the maximum value of " + max);
        }
        return value;
    }

    public static int deepHashCode(Object o) {
        if (o == null) {
            return 0;
        }
        if (!o.getClass().isArray()) {
            return o.hashCode();
        }
        if (o instanceof Object[]) {
            return Arrays.deepHashCode((Object[])o);
        }
        if (o instanceof boolean[]) {
            return Arrays.hashCode((boolean[])o);
        }
        if (o instanceof char[]) {
            return Arrays.hashCode((char[])o);
        }
        if (o instanceof byte[]) {
            return Arrays.hashCode((byte[])o);
        }
        if (o instanceof short[]) {
            return Arrays.hashCode((short[])o);
        }
        if (o instanceof int[]) {
            return Arrays.hashCode((int[])o);
        }
        if (o instanceof long[]) {
            return Arrays.hashCode((long[])o);
        }
        if (o instanceof float[]) {
            return Arrays.hashCode((float[])o);
        }
        if (o instanceof double[]) {
            return Arrays.hashCode((double[])o);
        }
        throw new AssertionError();
    }

    public static boolean deepEquals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        Class<?> type1 = o1.getClass();
        Class<?> type2 = o2.getClass();
        if (!type1.isArray() || !type2.isArray()) {
            return o1.equals(o2);
        }
        if (o1 instanceof Object[] && o2 instanceof Object[]) {
            return Arrays.deepEquals((Object[])o1, (Object[])o2);
        }
        if (type1 != type2) {
            return false;
        }
        if (o1 instanceof boolean[]) {
            return Arrays.equals((boolean[])o1, (boolean[])o2);
        }
        if (o1 instanceof char[]) {
            return Arrays.equals((char[])o1, (char[])o2);
        }
        if (o1 instanceof byte[]) {
            return Arrays.equals((byte[])o1, (byte[])o2);
        }
        if (o1 instanceof short[]) {
            return Arrays.equals((short[])o1, (short[])o2);
        }
        if (o1 instanceof int[]) {
            return Arrays.equals((int[])o1, (int[])o2);
        }
        if (o1 instanceof long[]) {
            return Arrays.equals((long[])o1, (long[])o2);
        }
        if (o1 instanceof float[]) {
            return Arrays.equals((float[])o1, (float[])o2);
        }
        if (o1 instanceof double[]) {
            return Arrays.equals((double[])o1, (double[])o2);
        }
        throw new AssertionError();
    }

    public static <T> Set<T> getAddedInTarget(Set<T> current, Set<T> target) {
        if (current == null || target == null) {
            return new HashSet();
        }
        return Utils.getDiff(target, current);
    }

    public static <T> Set<T> getDeletedInTarget(Set<T> current, Set<T> target) {
        if (current == null || target == null) {
            return new HashSet();
        }
        return Utils.getDiff(current, target);
    }

    private static <T> Set<T> getDiff(Set<T> source, Set<T> dest) {
        HashSet<T> diff = new HashSet<T>();
        for (T id : source) {
            if (dest.contains(id)) continue;
            diff.add(id);
        }
        return diff;
    }

    public static <T> List<T> sorted(List<T> l, Comparator<T> comparator) {
        ArrayList<T> copy = new ArrayList<T>(l);
        Collections.sort(copy, comparator);
        return copy;
    }

    public static <T extends Comparable<T>> List<T> sorted(List<T> l) {
        ArrayList<T> copy = new ArrayList<T>(l);
        Collections.sort(copy);
        return copy;
    }

    public static <T> List<T> reversed(List<T> l) {
        ArrayList<T> copy = new ArrayList<T>(l);
        Collections.reverse(copy);
        return copy;
    }

    public static <T> boolean compareList(List<T> listA, List<T> listB) {
        if (listA == null && listB == null) {
            return true;
        }
        if (listA == null || listB == null) {
            return false;
        }
        if (listA.size() != listB.size()) {
            return false;
        }
        return listA.containsAll(listB);
    }

    public static URI parseUri(String uri) {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new VoldemortException(e);
        }
    }

    public static <T1, T2> T1 uncheckedCast(T2 t2) {
        return (T1)t2;
    }

    public static boolean isSymLink(File symlinkFile) {
        try {
            File canonicalFile = null;
            if (symlinkFile.getParent() != null) {
                File canonicalDir = symlinkFile.getParentFile().getCanonicalFile();
                canonicalFile = new File(canonicalDir, symlinkFile.getName());
            } else {
                canonicalFile = symlinkFile;
            }
            return !canonicalFile.getCanonicalFile().equals(canonicalFile.getAbsoluteFile());
        }
        catch (IOException e) {
            return false;
        }
    }

    public static interface Posix
    extends Library {
        public int symlink(String var1, String var2);
    }
}

