/*
 * Decompiled with CFR 0.152.
 */
package voldemort.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.log4j.Logger;

public class VoldemortIOUtils {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final Logger logger = Logger.getLogger(VoldemortIOUtils.class);

    public static String toString(InputStream input, long limit) throws IOException {
        return VoldemortIOUtils.toString(input, null, limit);
    }

    public static void closeQuietly(HttpResponse httpResponse, String context) {
        if (httpResponse != null && httpResponse.getEntity() != null) {
            try {
                IOUtils.closeQuietly((InputStream)httpResponse.getEntity().getContent());
            }
            catch (Exception e) {
                logger.error((Object)("Error closing entity connection : " + context), (Throwable)e);
            }
        }
    }

    public static void closeQuietly(HttpResponse httpResponse) {
        VoldemortIOUtils.closeQuietly(httpResponse, "");
    }

    public static void closeQuietly(HttpClient httpClient) {
        if (httpClient != null) {
            httpClient.getConnectionManager().shutdown();
        }
    }

    public static String toString(InputStream input, String encoding, long limit) throws IOException {
        StringWriter sw = new StringWriter();
        VoldemortIOUtils.copy(input, sw, encoding, limit);
        return sw.toString();
    }

    public static void copy(InputStream input, Writer output, String encoding, long limit) throws IOException {
        if (encoding == null) {
            VoldemortIOUtils.copy(input, output, limit);
        } else {
            InputStreamReader in = new InputStreamReader(input, encoding);
            VoldemortIOUtils.copy(in, output, limit);
        }
    }

    public static void copy(InputStream input, Writer output, long limit) throws IOException {
        InputStreamReader in = new InputStreamReader(input);
        VoldemortIOUtils.copy(in, output, limit);
    }

    public static int copy(Reader input, Writer output, long limit) throws IOException {
        long count = VoldemortIOUtils.copyLarge(input, output, limit);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    public static long copyLarge(Reader input, Writer output, long limit) throws IOException {
        char[] buffer = new char[4096];
        long count = 0L;
        int n = 0;
        for (long remaining = limit; remaining > 0L; remaining -= (long)n) {
            int n2 = n = remaining > 4096L ? input.read(buffer) : input.read(buffer, 0, (int)remaining);
            if (n == -1) break;
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }
}

