/*
 * Decompiled with CFR 0.152.
 */
package voldemort.versioning;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import voldemort.versioning.InconsistencyResolver;
import voldemort.versioning.ObjectMerger;
import voldemort.versioning.VectorClock;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergingInconsistencyResolver<T>
implements InconsistencyResolver<Versioned<T>> {
    private final ObjectMerger<T> merger;

    public MergingInconsistencyResolver(ObjectMerger<T> merger) {
        this.merger = merger;
    }

    @Override
    public List<Versioned<T>> resolveConflicts(List<Versioned<T>> items) {
        if (items.size() <= 1) {
            return items;
        }
        Iterator<Versioned<T>> iter = items.iterator();
        Versioned<T> current = iter.next();
        T merged = current.getValue();
        VectorClock clock = (VectorClock)current.getVersion();
        while (iter.hasNext()) {
            Versioned<T> versioned = iter.next();
            merged = this.merger.merge(merged, versioned.getValue());
            clock = clock.merge((VectorClock)versioned.getVersion());
        }
        return Collections.singletonList(new Versioned<T>(merged, clock));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MergingInconsistencyResolver that = (MergingInconsistencyResolver)o;
        return !(this.merger != null ? !this.merger.equals(that.merger) : that.merger != null);
    }

    public int hashCode() {
        return this.merger != null ? this.merger.hashCode() : 0;
    }
}

