/*
 * Decompiled with CFR 0.152.
 */
package voldemort.client.rebalance.task;

import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import voldemort.client.protocol.admin.AdminClient;
import voldemort.client.rebalance.RebalanceClientConfig;
import voldemort.client.rebalance.RebalancePartitionsInfo;
import voldemort.client.rebalance.task.RebalanceTask;
import voldemort.store.UnreachableStoreException;
import voldemort.utils.RebalanceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DonorBasedRebalanceTask
extends RebalanceTask {
    protected static final Logger logger = Logger.getLogger(DonorBasedRebalanceTask.class);
    private final int donorNodeId;

    public DonorBasedRebalanceTask(int taskId, List<RebalancePartitionsInfo> stealInfos, RebalanceClientConfig config, Semaphore donorPermit, AdminClient adminClient) {
        super(taskId, stealInfos, config, donorPermit, adminClient);
        RebalanceUtils.assertSameDonor(stealInfos, -1);
        this.donorNodeId = stealInfos.get(0).getDonorId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block5: {
            int rebalanceAsyncId = -1;
            try {
                try {
                    RebalanceUtils.printLog(this.taskId, logger, "Acquiring donor permit for node " + this.donorNodeId + " for " + this.stealInfos);
                    this.donorPermit.acquire();
                    RebalanceUtils.printLog(this.taskId, logger, "Starting on node " + this.donorNodeId + " rebalancing task " + this.stealInfos);
                    rebalanceAsyncId = this.adminClient.rebalanceNode(this.stealInfos);
                    this.adminClient.waitForCompletion(this.donorNodeId, rebalanceAsyncId, this.config.getRebalancingClientTimeoutSeconds(), TimeUnit.SECONDS);
                    RebalanceUtils.printLog(this.taskId, logger, "Succesfully finished rebalance for async operation id " + rebalanceAsyncId);
                }
                catch (UnreachableStoreException e) {
                    this.exception = e;
                    logger.error((Object)("Donor node " + this.donorNodeId + " is unreachable, please make sure it is up and running : " + e.getMessage()), (Throwable)e);
                    Object var4_3 = null;
                    this.donorPermit.release();
                    this.isComplete.set(true);
                    break block5;
                }
                catch (Exception e) {
                    this.exception = e;
                    logger.error((Object)("Rebalance failed : " + e.getMessage()), (Throwable)e);
                    Object var4_4 = null;
                    this.donorPermit.release();
                    this.isComplete.set(true);
                }
                Object var4_2 = null;
                this.donorPermit.release();
                this.isComplete.set(true);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.donorPermit.release();
                this.isComplete.set(true);
                throw throwable;
            }
        }
    }

    @Override
    public String toString() {
        return "Donor based rebalance task on donor node " + this.donorNodeId + " : " + this.getStealInfos();
    }
}

