/*
 * Decompiled with CFR 0.152.
 */
package voldemort.server.rebalance.async;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import voldemort.client.protocol.admin.AdminClient;
import voldemort.client.rebalance.RebalancePartitionsInfo;
import voldemort.server.VoldemortConfig;
import voldemort.server.rebalance.Rebalancer;
import voldemort.server.rebalance.VoldemortRebalancingException;
import voldemort.server.rebalance.async.RebalanceAsyncOperation;
import voldemort.store.metadata.MetadataStore;
import voldemort.utils.RebalanceUtils;

public class StealerBasedRebalanceAsyncOperation
extends RebalanceAsyncOperation {
    private List<Integer> rebalanceStatusList;
    private final RebalancePartitionsInfo stealInfo;

    public StealerBasedRebalanceAsyncOperation(Rebalancer rebalancer, VoldemortConfig voldemortConfig, MetadataStore metadataStore, int requestId, RebalancePartitionsInfo stealInfo) {
        super(rebalancer, voldemortConfig, metadataStore, requestId, "Stealer based rebalance : " + stealInfo);
        this.rebalancer = rebalancer;
        this.stealInfo = stealInfo;
        this.rebalanceStatusList = new ArrayList<Integer>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void operate() throws Exception {
        this.adminClient = RebalanceUtils.createTempAdminClient(this.voldemortConfig, this.metadataStore.getCluster(), this.voldemortConfig.getMaxParallelStoresRebalancing());
        final ArrayList<Exception> failures = new ArrayList<Exception>();
        final ConcurrentLinkedQueue storesRebalancing = new ConcurrentLinkedQueue();
        final AtomicInteger completedStoresCount = new AtomicInteger(0);
        final int totalStoresCount = this.stealInfo.getUnbalancedStoreList().size();
        try {
            for (final String storeName : ImmutableList.copyOf(this.stealInfo.getUnbalancedStoreList())) {
                this.executors.submit(new Runnable(){

                    public void run() {
                        try {
                            boolean isReadOnlyStore = StealerBasedRebalanceAsyncOperation.this.metadataStore.getStoreDef(storeName).getType().compareTo("read-only") == 0;
                            storesRebalancing.add(storeName);
                            StealerBasedRebalanceAsyncOperation.this.updateStatus(StealerBasedRebalanceAsyncOperation.this.getHeader(StealerBasedRebalanceAsyncOperation.this.stealInfo) + "Completed working on " + completedStoresCount.get() + " out of " + totalStoresCount + " stores. Still rebalancing " + storesRebalancing);
                            StealerBasedRebalanceAsyncOperation.this.rebalanceStore(storeName, StealerBasedRebalanceAsyncOperation.this.adminClient, StealerBasedRebalanceAsyncOperation.this.stealInfo, isReadOnlyStore);
                            StealerBasedRebalanceAsyncOperation.this.stealInfo.removeStore(storeName);
                            storesRebalancing.remove(storeName);
                            completedStoresCount.getAndIncrement();
                            StealerBasedRebalanceAsyncOperation.this.updateStatus(StealerBasedRebalanceAsyncOperation.this.getHeader(StealerBasedRebalanceAsyncOperation.this.stealInfo) + "Completed working on " + completedStoresCount.get() + " out of " + totalStoresCount + " stores. Still rebalancing " + storesRebalancing);
                        }
                        catch (Exception e) {
                            RebalanceAsyncOperation.logger.error((Object)(StealerBasedRebalanceAsyncOperation.this.getHeader(StealerBasedRebalanceAsyncOperation.this.stealInfo) + "Error while rebalancing for store " + storeName + " - " + e.getMessage()), (Throwable)e);
                            failures.add(e);
                        }
                    }
                });
            }
            this.waitForShutdown();
            ArrayList unbalancedStores = Lists.newArrayList(this.stealInfo.getUnbalancedStoreList());
            if (!unbalancedStores.isEmpty()) {
                throw new VoldemortRebalancingException(this.getHeader(this.stealInfo) + "Failed to rebalance task " + this.stealInfo + ". Could only complete " + completedStoresCount.get() + " out of " + totalStoresCount + " stores", failures);
            }
            logger.info((Object)(this.getHeader(this.stealInfo) + "Rebalance of " + this.stealInfo + " completed successfully for all " + totalStoresCount + " stores"));
            this.updateStatus(this.getHeader(this.stealInfo) + "Rebalance of " + this.stealInfo + " completed successfully for all " + totalStoresCount + " stores");
            this.metadataStore.deleteRebalancingState(this.stealInfo);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            logger.info((Object)(this.getHeader(this.stealInfo) + "Releasing permit for donor node " + this.stealInfo.getDonorId()));
            this.rebalancer.releaseRebalancingPermit(this.stealInfo.getDonorId());
            this.adminClient.stop();
            this.adminClient = null;
            throw throwable;
        }
        logger.info((Object)(this.getHeader(this.stealInfo) + "Releasing permit for donor node " + this.stealInfo.getDonorId()));
        this.rebalancer.releaseRebalancingPermit(this.stealInfo.getDonorId());
        this.adminClient.stop();
        this.adminClient = null;
    }

    public void stop() {
        this.updateStatus(this.getHeader(this.stealInfo) + "Stop called on rebalance operation");
        if (null != this.adminClient) {
            for (int asyncID : this.rebalanceStatusList) {
                this.adminClient.stopAsyncRequest(this.metadataStore.getNodeId(), asyncID);
            }
        }
        this.executors.shutdownNow();
    }

    private String getHeader(RebalancePartitionsInfo stealInfo) {
        return "Stealer " + stealInfo.getStealerId() + ", Donor " + stealInfo.getDonorId() + "] ";
    }

    private void rebalanceStore(String storeName, AdminClient adminClient, RebalancePartitionsInfo stealInfo, boolean isReadOnlyStore) {
        if (stealInfo.getReplicaToAddPartitionList(storeName) != null && stealInfo.getReplicaToAddPartitionList(storeName).size() > 0) {
            logger.info((Object)(this.getHeader(stealInfo) + "Starting partitions migration for store " + storeName + " from donor node " + stealInfo.getDonorId()));
            int asyncId = adminClient.migratePartitions(stealInfo.getDonorId(), this.metadataStore.getNodeId(), storeName, stealInfo.getReplicaToAddPartitionList(storeName), null, stealInfo.getInitialCluster(), true);
            this.rebalanceStatusList.add(asyncId);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this.getHeader(stealInfo) + "Waiting for completion for " + storeName + " with async id " + asyncId));
            }
            adminClient.waitForCompletion(this.metadataStore.getNodeId(), asyncId, this.voldemortConfig.getRebalancingTimeoutSec(), TimeUnit.SECONDS, this.getStatus());
            this.rebalanceStatusList.remove((Object)asyncId);
            logger.info((Object)(this.getHeader(stealInfo) + "Completed partition migration for store " + storeName + " from donor node " + stealInfo.getDonorId()));
        }
        if (stealInfo.getReplicaToDeletePartitionList(storeName) != null && stealInfo.getReplicaToDeletePartitionList(storeName).size() > 0 && !isReadOnlyStore) {
            logger.info((Object)(this.getHeader(stealInfo) + "Deleting partitions for store " + storeName + " on donor node " + stealInfo.getDonorId()));
            adminClient.deletePartitions(stealInfo.getDonorId(), storeName, stealInfo.getReplicaToDeletePartitionList(storeName), stealInfo.getInitialCluster(), null);
            logger.info((Object)(this.getHeader(stealInfo) + "Deleted partitions for store " + storeName + " on donor node " + stealInfo.getDonorId()));
        }
        logger.info((Object)(this.getHeader(stealInfo) + "Finished all migration for store " + storeName));
    }
}

