/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.routed;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import voldemort.annotations.concurrency.Threadsafe;
import voldemort.store.routed.NodeValue;
import voldemort.versioning.Occurred;
import voldemort.versioning.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Threadsafe
public class ReadRepairer<K, V> {
    public List<NodeValue<K, V>> getRepairs(List<NodeValue<K, V>> nodeValues) {
        int size = nodeValues.size();
        if (size <= 1) {
            return Collections.emptyList();
        }
        HashMap keyToNodeValues = Maps.newHashMap();
        for (NodeValue<K, V> nodeValue : nodeValues) {
            List keyNodeValues = (List)keyToNodeValues.get(nodeValue.getKey());
            if (keyNodeValues == null) {
                keyNodeValues = Lists.newArrayListWithCapacity((int)5);
                keyToNodeValues.put(nodeValue.getKey(), keyNodeValues);
            }
            keyNodeValues.add(nodeValue);
        }
        ArrayList result = Lists.newArrayList();
        for (List keyNodeValues : keyToNodeValues.values()) {
            result.addAll(this.singleKeyGetRepairs(keyNodeValues));
        }
        return result;
    }

    private List<NodeValue<K, V>> singleKeyGetRepairs(List<NodeValue<K, V>> nodeValues) {
        NodeValue repair;
        int size = nodeValues.size();
        if (size <= 1) {
            return Collections.emptyList();
        }
        HashSet<Integer> obsolete = new HashSet<Integer>(3);
        HashMultimap concurrents = HashMultimap.create();
        concurrents.put((Object)nodeValues.get(0).getVersion(), nodeValues.get(0));
        for (int i = 1; i < nodeValues.size(); ++i) {
            NodeValue<K, V> curr = nodeValues.get(i);
            boolean concurrentToAll = true;
            HashSet versions = new HashSet(concurrents.keySet());
            for (Version concurrentVersion : versions) {
                if (curr.getVersion().equals(concurrentVersion)) {
                    concurrents.put((Object)curr.getVersion(), curr);
                    break;
                }
                Occurred occurred = curr.getVersion().compare(concurrentVersion);
                if (occurred == Occurred.BEFORE) {
                    obsolete.add(curr.getNodeId());
                    concurrentToAll = false;
                    break;
                }
                if (occurred != Occurred.AFTER) continue;
                for (NodeValue v : concurrents.get((Object)concurrentVersion)) {
                    obsolete.add(v.getNodeId());
                }
                concurrents.removeAll((Object)concurrentVersion);
                concurrentToAll = false;
                concurrents.put((Object)curr.getVersion(), curr);
            }
            if (!concurrentToAll) continue;
            concurrents.put((Object)curr.getVersion(), curr);
        }
        ArrayList<NodeValue<K, V>> repairs = new ArrayList<NodeValue<K, V>>(3);
        for (Integer id : obsolete) {
            for (Version v : concurrents.keySet()) {
                NodeValue concurrent = (NodeValue)concurrents.get((Object)v).iterator().next();
                repair = new NodeValue(id, concurrent.getKey(), concurrent.getVersioned());
                repairs.add(repair);
            }
        }
        if (concurrents.size() > 1) {
            HashSet<NodeValue<K, V>> existing = new HashSet<NodeValue<K, V>>(repairs);
            for (NodeValue entry1 : concurrents.values()) {
                for (NodeValue entry2 : concurrents.values()) {
                    if (entry1.getVersion().equals(entry2.getVersion()) || existing.contains(repair = new NodeValue(entry1.getNodeId(), entry2.getKey(), entry2.getVersioned()))) continue;
                    repairs.add(repair);
                }
            }
        }
        return repairs;
    }
}

