/*
 * Decompiled with CFR 0.152.
 */
package voldemort.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkClassLoader
extends ClassLoader {
    private static final Logger logger = Logger.getLogger(NetworkClassLoader.class);

    public NetworkClassLoader(ClassLoader parentClassLoader) {
        super(parentClassLoader);
    }

    public Class<?> loadClass(String className, byte[] classBuffer, int offset, int length) {
        Class<?> loadedClass = super.findLoadedClass(className);
        if (null == loadedClass) {
            return super.defineClass(className, classBuffer, offset, length);
        }
        return loadedClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] dumpClass(Class<?> cl) throws IOException {
        String filename = cl.getName().replace('.', File.separatorChar) + ".class";
        InputStream in = null;
        logger.debug((Object)("NetworkClassloader dumpClass() :" + cl.getCanonicalName()));
        try {
            byte[] classBytes;
            in = this.getResourceAsStream(filename);
            byte[] byArray = classBytes = IOUtils.toByteArray((InputStream)in);
            return byArray;
        }
        finally {
            if (null != in) {
                in.close();
            }
        }
    }
}

