package eu.cloudscale.showcase.db.model.hibernate;

// Generated May 16, 2013 3:07:18 PM by Hibernate Tools 4.0.0

import static javax.persistence.GenerationType.IDENTITY;

import java.util.HashSet;
import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;

import eu.cloudscale.showcase.db.model.IAddress;
import eu.cloudscale.showcase.db.model.ICcXacts;
import eu.cloudscale.showcase.db.model.ICountry;

/**
 * Country generated by hbm2java
 */
@Entity
@Table( name = "country", catalog = "tpcw" )
public class Country implements ICountry
{

	private Integer      coId;

	private String      coName;

	private Double      coExchange;

	private String      coCurrency;

	private Set<IAddress> addresses = new HashSet<IAddress>( 0 );

	private Set<ICcXacts> ccXactses = new HashSet<ICcXacts>( 0 );

	public Country()
	{
	}

	public Country(String coName, Double coExchange, String coCurrency,
	        Set<IAddress> addresses, Set<ICcXacts> ccXactses)
	{
		this.coName = coName;
		this.coExchange = coExchange;
		this.coCurrency = coCurrency;
		this.addresses = addresses;
		this.ccXactses = ccXactses;
	}

	@Id
	@GeneratedValue( strategy = IDENTITY )
	@Column( name = "CO_ID", unique = true, nullable = false )
	@Override
	public Integer getCoId()
	{
		return this.coId;
	}

	@Override
	public void setCoId(Integer coId)
	{
		this.coId = coId;
	}

	@Column( name = "CO_NAME", length = 50 )
	@Override
	public String getCoName()
	{
		return this.coName;
	}

	@Override
	public void setCoName(String coName)
	{
		this.coName = coName;
	}

	@Column( name = "CO_EXCHANGE", precision = 22, scale = 0 )
	@Override
	public Double getCoExchange()
	{
		return this.coExchange;
	}

	@Override
	public void setCoExchange(Double coExchange)
	{
		this.coExchange = coExchange;
	}

	@Column( name = "CO_CURRENCY", length = 18 )
	@Override
	public String getCoCurrency()
	{
		return this.coCurrency;
	}

	@Override
	public void setCoCurrency(String coCurrency)
	{
		this.coCurrency = coCurrency;
	}

	@OneToMany( targetEntity=Address.class, fetch = FetchType.LAZY, mappedBy = "country" )
	public Set<IAddress> getAddresses()
	{
		return this.addresses;
	}

	public void setAddresses(Set<IAddress> addresses)
	{
		this.addresses = addresses;
	}

	@OneToMany( targetEntity=CcXacts.class, fetch = FetchType.LAZY, mappedBy = "country" )
	public Set<ICcXacts> getCcXactses()
	{
		return this.ccXactses;
	}

	public void setCcXactses(Set<ICcXacts> ccXactses)
	{
		this.ccXactses = ccXactses;
	}

}
